# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 10
# Experiment: PMxPM, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR10_strategy.txt
# LLM Suggested Fallback: Not Provided

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR10(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Round 1: Cooperate to signal willingness to cooperate
    if current_round == 1:
        return "C"
    
    # Check for unconditional strategies in opponent's code
    if "always D" in opponent_program_code or "return 'D'" in opponent_program_code:
        return "D"
    if "always C" in opponent_program_code or "return 'C'" in opponent_program_code:
        return "D"
    
    # Round 2: Exploit opponent's initial cooperation or defect if they defected
    if current_round == 2:
        if opp_history[0] == "C":
            return "D"
        else:
            return "D"
    
    # Rounds 3-10: Tit-for-Tat (mirror opponent's previous move)
    return opp_history[-1]